/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketFluidTankChange
extends APacketEntity<EntityFluidTank> {
    private final String fluidName;
    private final String fluidModName;
    private final double fluidDelta;

    public PacketFluidTankChange(EntityFluidTank tank, double fluidDelta) {
        super(tank);
        this.fluidName = tank.getFluid();
        this.fluidModName = tank.getFluidMod();
        this.fluidDelta = fluidDelta;
    }

    public PacketFluidTankChange(ByteBuf buf) {
        super(buf);
        this.fluidName = PacketFluidTankChange.readStringFromBuffer(buf);
        this.fluidModName = PacketFluidTankChange.readStringFromBuffer(buf);
        this.fluidDelta = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketFluidTankChange.writeStringToBuffer(this.fluidName, buf);
        PacketFluidTankChange.writeStringToBuffer(this.fluidModName, buf);
        buf.writeDouble(this.fluidDelta);
    }

    @Override
    public boolean handle(AWrapperWorld world, EntityFluidTank tank) {
        if (this.fluidDelta < 0.0) {
            tank.drain(this.fluidName, this.fluidModName, -this.fluidDelta, true);
        } else {
            tank.fill(this.fluidName, this.fluidModName, this.fluidDelta, true);
        }
        return true;
    }
}

